<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

## 技术支持

### 使用“IoTDB”的项目和产品名称

其他组织或企业在使用 Apache IoTDB 建立项目或者产品时，应该应该注意尊重“Apache IoTDB”的商标。
具体事项请参阅 [ASF Trademarks Guidance](https://www.apache.org/foundation/marks/)
和 [FAQ](https://www.apache.org/foundation/marks/faq/)。

一般来说，我们建议不要仅使用"IoTDB"在任何名字中，以避免出现商标风险。
例如，不应该给自己的产品命名为"IoTDB 大数据产品"，因为这个名字中包含 IoTDB。然而，如果说是命名为"Apache IoTDB 赋能的大数据产品"，
或者"基于 Apache IoTDB 的大数据产品"， 这种名字就是被允许的。
简单来说，当你想在名字中出现 IoTDB 时，应为"Apache IoTDB"，而不是仅"IoTDB"。

在你（在 Maven 或者其他模块名中）创建软件标识时，可以命名为例如"iotdb-tool"。

在产品描述中明确指出 Apache IoTDB 也是可以的，例如"该大数据产品是 Apache IoTDB 的一个子产品"。

### 相关贡献或应用的公司和组织
要将自己添加到列表中，请给 dev@iotdb.apache.org 发送电子邮件，其中包含您的组织名称，URL，正在使用的 IoTDB 组件列表以及用例的简短描述。
你也可以在 [Github](https://github.com/apache/iotdb/issues/748) 留言。

- 清华大学软件学院和大数据系统软件国家工程实验室最初开发了 IoTDB，并捐献给 Apache。
	- 我们有很多研究生和专业软件工程师在持续开发 IoTDB
	- 我们在上海地铁和其他两个城市的地铁管理中使用 IoTDB。
	- 我们在中国气象局使用 IoTDB 管理超过 10 年的站点实况数据。
	
- 联想开发了 TsFile 的 Go 语言版本，并用于长飞光纤项目。该项目收集了超过 9 万个测点，并基于 TsFile 同步到云端。

- 金风科技使用 IoTDB 管理风机数据。他们首先从 Kafka 消费 SCADA 数据，然后写入 IoTDB 并从 IoTDB 进行查询。

- 大唐先一将 IoTDB 部署在了中国的许多电厂。
 
- 北京智创新科使用 IoTDB 存储中国铁塔的 2 百万铁塔的蓄电池数据。

- 北京清智物联使用 IoTDB 收集调相机（发电机）的监控数据。

- 建龙钢铁在测试 IoTDB。
